<?php 

class WC_GTPaySetup {
	
	var $config = null;

	function __construct(){
		
	}

	function read_config(){
        $this->config = include plugin_dir_path(__FILE__) . "settings.php";
		return $this->config;
	} 

	function init_form_fields($obj) {
        $obj->form_fields = array(
            'enabled' => array(
                    'title' => __('Enable/Disable', $this->config["id"]),
                    'type' => 'checkbox',
                    'label' => __('Enable GTPay Payment Module.', $this->config["id"]),
                    'default' => 'no'),
            'title' => array(
                    'title' => __('Title', $this->config["id"]),
                    'type' => 'text',
                    'description' => __('This controls the title which the user sees during checkout.', $this->config["id"]),
                    'default' => __($this->config["title"], $this->config["id"])),
            'description' => array(
                    'title' => __('Description', $this->config["id"]),
                    'type' => 'textarea',
                    'description' => __('This controls the description which the user sees during checkout.', $this->config["id"]),
                    'default' => __($this->config["description"], $this->config["id"])),
            'gtpay_mert_id' => array(
                    'title' => __('GTPay Merchant Id', $this->config["id"]),
                    'type' => 'text',
                    'description' => __('', $this->config["id"])),
            'hashkey' => array(
                    'title' => __('Hash Key', $this->config["id"]),
                    'type' => 'text',
                    'description' => __('', $this->config["id"])),
            'gtpay_tranx_curr' => array(
                    'title' => __('Currency', $this->config["id"]),
                    'type' => 'select',
                    'options' => array(
                        "566" => "Naira", 
                        "840" => "USD")),
            'sandbox' => array(
                    'title' => __('Sandbox', $this->config["id"]),
                    'type' => 'checkbox',
                    'description' => __('Enable/Disable sandbox mode', 'gtpay')),
        );
    }

	function __initialize($plugin){
		add_filter('woocommerce_currencies', array(&$this, 'add_gtpay_currency'));
	    add_filter('woocommerce_currency_symbol', array(&$this, 'add_gtpay_currency_symbol'), 10, 2);
	    add_filter("plugin_action_links_$plugin", array(&$this, 'add_gtpay_settings_link'));
	    add_filter('woocommerce_payment_gateways', array(&$this, 'add_gtpay_gateway'));
	}

    function add_gtpay_currency($currencies) {
        $currencies['Naira'] = __('Naira', 'woocommerce');
        $currencies['USD'] = __('US Dollar', 'woocommerce');
        return $currencies;
    }

	function add_gtpay_currency_symbol($currency_symbol, $currency) {
        switch ($currency) {
            case 'Naira':
                $currency_symbol = '₦ ';
                break;
            case 'USD':
                $currency_symbol = '$ ';
                break;
        }
        return $currency_symbol;
    }

    function add_gtpay_settings_link($links) {
     	$settings_link = '<a href="admin.php?page=wc-settings&tab=checkout&section=WC_GTPaypayment">Settings</a>';
        array_unshift($links, $settings_link);
        return $links;
    }

    function add_gtpay_gateway($methods) {
        $methods[] = 'WC_GTPayPayment';
        return $methods;
    }
}