<?php

/*
  Plugin Name: GTPay Woocommerce Payment Gateway
  Plugin URI: https://wordpress.org/plugins/search/gtpay/
  Description: GTPay is a Guaranty Trust Bank’s payment gateway which facilitates merchant collection from their website. It offers the options for local and international credit/debit cards, Bank Transfers from any Nigerian Bank as well as Mobile Money wallets and is constantly being extended to offer more payment options to your clients.
  Version: 3.4
  Author: Delu Akin
  Author URI: https://www.facebook.com/deluakin
 */

if (!defined('ABSPATH')) 
    exit("No script kiddies");

if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))){
    echo "<div class='error notice'><p>Woocommerce has to be installed and active to use the <b>GTPay WooCommerce Payment Gateway</b> plugin</p></div>";
    return;
}

add_action('plugins_loaded', 'GTPay_payment_init', 0);

function GTPay_payment_init() {
    if (!class_exists('WC_Payment_Gateway')){
        echo "<div class='error notice'><p>Woocommerce has to be installed and active to use <b>GTPay WooCommerce Payment Gateway</b> plugin</p></div>";
        return;
    }

    $plugin = plugin_basename(__FILE__);
    require plugin_dir_path(__FILE__) . "/includes/class-hu-setup.php";
    $setup = new WC_GTPaySetup();
    $setup->__initialize($plugin);

    class WC_GTPayPayment extends WC_Payment_Gateway {
        var $config = null;
        var $setup = null;

        public function __construct() {
            $this->setup = new WC_GTPaySetup();
            $this->config = $this->setup->read_config();

            $this->id = $this->config["id"];
            $this->method_title = __($this->config["title"], 'woocommerce' );
            $this->icon = $this->config["icon"];
            $this->has_fields = false;

            $this->setup->init_form_fields($this);
            $this->init_settings();

            $this->title = $this->config["title"];
            $this->description = $this->config["description"];
            
            $this->nxt = $this->config['nxt'];
            $this->payment_successful = $this->config['payment_successful'];
            $this->payment_failed = $this->config['payment_failed'];
            $this->payment_session = $this->config['payment_session'];
            $this->email_notification = $this->config['email_notification'];

            $this->gtpay_mert_id = $this->settings['gtpay_mert_id'];
            $this->gtpay_tranx_curr = $this->settings['gtpay_tranx_curr'];
            $this->hashkey = $this->settings['hashkey'];

            if ($this->settings['sandbox'] == "yes") {
                $this->posturl = $this->config['s_payment_endpoint'];
                $this->geturl = $this->config['s_response_endpoint'];
            } else {
                $this->posturl = $this->config['payment_endpoint'];
                $this->geturl = $this->config['response_endpoint'];
            }

            if (isset($_POST["gtpay_tranx_status_code"])) {
                if(!class_exists("WC_GTPayResponse")){
                    require plugin_dir_path(__FILE__) . "/includes/class-hu-response.php";
                }

                $resp_obj = new WC_GTPayResponse($this);
                $resp_obj->get_response();
            }

            if (isset($_REQUEST["gtpay"])) {
                wc_add_notice($_REQUEST["gtpay"], "error");
            }

            if (version_compare(WOOCOMMERCE_VERSION, '2.0.0', '>=')) {
                add_action('woocommerce_update_options_payment_gateways_' . $this->id, array(&$this, 'process_admin_options'));
            } else {
                add_action('woocommerce_update_options_payment_gateways', array(&$this, 'process_admin_options'));
            }

            add_action('woocommerce_receipt_gtpay', array(&$this, 'receipt_page'));
        }

        public function admin_options() {
            #Generate the HTML For the settings form.
            echo '<h3>' . __('GTPay Payment Gateway', 'GTPay') . '</h3>';
            echo '<p>' . __('GTPay Payment is most popular payment gateway for online shopping in Nigeria. <br><small><b>For premium/custom features contact elnino.akin@gmail.com</b></small>') . '</p>';
            echo '<table class="form-table">';
            $this->generate_settings_html();
            echo '</table>';
            wp_enqueue_script('gtpay_admin_option_js', plugin_dir_url(__FILE__) . 'assets/js/settings.js', array('jquery'), '1.0.1');
        }

        protected function get_payment_args($order) {
            global $woocommerce;

            $txnid = $order->id . '_' . date("ymds");
            $redirect_url = $woocommerce->cart->get_checkout_url();
            $productinfo = "Order: " . $order->id;
            $str = "$this->merchant_id|$txnid|$order->get_order_total()|$productinfo|$order->billing_first_name|$order->billing_email|||||||||||$this->salt";
            $hash = hash('sha512', $str);

            WC()->session->set('GTPay_wc_hash_key', $hash);
            $items = $woocommerce->cart->get_cart();
            $GTPay_items = array();
			$item_index = 0;
            foreach ($items as $item) {
                $GTPay_items["item_" . $item_index] = array(
                    "name" => $item["data"]->post->post_title,
                    "quantity" => $item["quantity"],
                    "unit_price" => $item["line_total"] / (($item["quantity"] == 0) ? 1 : $item["quantity"]),
                    "total_price" => $item["line_total"],
                    "description" => ""
                );
				$item_index++;
            }
            $GTPaypayment_args = array(
                "invoice" => array(
                    "items" => $mpower_items,
                    "total_amount" => $order->order_total,
                    "description" => "Payment of GHs" . $order->order_total . " for item(s) bought on " . get_bloginfo("name")
                ), "store" => array(
                    "name" => get_bloginfo("name"),
                    "website_url" => get_site_url()
                ), "actions" => array(
                    "cancel_url" => $redirect_url,
                    "return_url" => $redirect_url
                ), "custom_data" => array(
                    "order_id" => $order->id,
                    "trans_id" => $txnid,
                    "hash" => $hash
                )
            );


            apply_filters('woocommerce_GTPaypayment_args', $GTPaypayment_args, $order);
            return $GTPaypayment_args;
        }

        function receipt_page($order) {
            global $woocommerce;

            $order = new WC_Order($order);
            $items = $order->get_items();

            $item_rows = "";
            $currency = get_woocommerce_currency_symbol();
            $css = "<style>
                    .label-info{
                        background-color: green;
                        color: #f4f4f4;
                        padding: 5px;
                    }
                    tbody tr td { border-bottom: 1px solid; }
                    tbody tr{
                        font-size:14px;
                    }
                    thead{
                        font-size:16px;
                    }
                    tbody tr td{
                        padding: 10px 0px;
                    }tr:nth-child(even) {
                        background-color: #f4f4f4;
                    }
                    tfoot tr td:nth-child(1){
                        font-weight: bold;
                        font-size: 22px;
                        padding: 10px 0px 0px 10px;
                    }
                    </style>";
            echo $css;
            $price_total = 0;

            $order_data = new WC_Order($order);
            $shipping = $order_data->get_shipping_method();
            $shipping_rate = $order_data->get_total_shipping();
            
            foreach ($items as $item) {
                $product_name = $item['name'];
                $quantity = $item['quantity'];
                $product_id = $item['product_id'];

                $price = get_post_meta($product_id, '_price', true) * $quantity;
                $price_total += $price;
                $item_rows .= '<tr><td>' . $product_name . '</td><td>' . $quantity . '</td><td>' . $price . '</td> </tr>';
            }

            $item_rows .= "<tr><td><b><i>Sub Total</i></b></td><td></td><td>" . $price_total . "</td></tr>";
            if ($shipping && $shipping <> "") {
                $item_rows .= "<tr><td><b><i>Shipping(" . $shipping
                        . ")</i></b></td><td></td><td>" . $shipping_rate
                        . "</td></tr>";
            }
            if ($shipping_rate > 0) {
                $price_total += $shipping_rate;
            }
            $confirmation_table = '<p><span class="label-info">Please review your order then click on "Pay via GTPay" button</span></p>
                                    <br><h2>Your Order</h2>
                                    <table><thead><tr><th>Product</th><th>Qty</th><th>Amount(' . trim($currency) . ')</th></tr><thead>
                                    <tbody>' . $item_rows . '</tbody>
                                    <tfoot><tr><td><b>Grand Total</b></td><td></td><td><b>' . $currency . $price_total .
                    '</b></td></tr></tfoot></table>';

            echo $confirmation_table;
            echo $this->generate_gtpay_form($order);
        }

        function generate_gtpay_form($order_id) {
            global $woocommerce;

            $order = new WC_Order($order_id);
            $order_id = ( WC()->version < '2.7.0' ) ? $order->id : $order->get_id();
            $order_total = ( WC()->version < '2.7.0' ) ? $order->order_total : $order->get_total();
            $order_total *= 100;
            $billing_lname = ( WC()->version < '2.7.0' ) ? $order->billing_last_name : $order->get_billing_last_name();
            $billing_fname = ( WC()->version < '2.7.0' ) ? $order->billing_first_name : $order->get_billing_first_name();
            $txnid = $order->get_id() . '_' . date("ymds");

            $user_id = get_post_meta($order_id, '_customer_user', true);
            $redirect_url = $woocommerce->cart->get_checkout_url();
            $gtpay_cust_id = get_user_meta($user_id, 'billing_email', true);

            $gtpay_hash = $this->gtpay_mert_id . $txnid . $order_total . $this->gtpay_tranx_curr
                    . $gtpay_cust_id . $redirect_url . $this->hashkey;
            $hash = hash('sha512', $gtpay_hash);

            $gtpay_args = array(
                'gtpay_mert_id' => $this->gtpay_mert_id,
                'gtpay_tranx_id' => $txnid,
                'gtpay_tranx_amt' => $order_total,
                'gtpay_tranx_curr' => $this->gtpay_tranx_curr,
                'gtpay_cust_id' => $gtpay_cust_id,
                'gtpay_cust_name' => trim($billing_lname . ' ' . $billing_fname),
                'gtpay_hash' => $hash,
                'gtpay_tranx_noti_url' => $redirect_url,
                'gtpay_echo_data' => $order_id . ";" . $hash
            );

            $gtpay_args_array = array();
            foreach ($gtpay_args as $key => $value) {
                $gtpay_args_array[] = "<input type='hidden' name='$key' value='$value'/>";
            }
            return '<form action="' . $this->posturl . '" method="post" id="gtpay_payment_form">
            ' . implode('', $gtpay_args_array) . '
            <input type="submit" class="button-alt" id="submit_gtpay_payment_form" value="' . __('Pay via GTPay', 'gtpay') . '" /> <a class="button cancel" href="' . $order->get_cancel_order_url() . '">' . __('Cancel order &amp; restore cart', 'gtpay') . '</a>
            <script type="text/javascript">
                function processGTPayJSPayment(){
                jQuery("body").block(
                        {
                            message: "<img src=\"' . plugins_url('assets/images/ajax-loader.gif', __FILE__) . '\" alt=\"redirecting...\" style=\"float:left; margin-right: 10px;\" />' . __('Thank you for your order. We are now redirecting you to Payment Gateway to make payment.', 'gtpay') . '",
                                overlayCSS:
                        {
                            background: "#fff",
                                opacity: 0.6
                    },
                    css: {
                        padding:        20,
                            textAlign:      "center",
                            color:          "#555",
                            border:         "3px solid #aaa",
                            backgroundColor:"#fff",
                            cursor:         "wait",
                            lineHeight:"32px"
                    }
                    });
                    jQuery("#gtpay_payment_form").submit();
                    }
                    jQuery("#submit_gtpay_payment_form").click(function (e) {
                        e.preventDefault();
                        processGTPayJSPayment();
                    });
            </script>
            </form>';
        }

        function process_payment($order_id) {
            global $woocommerce;
            $order = new WC_Order($order_id);
            return array(
                'result' => 'success',
                'redirect' => add_query_arg(
                        'order-pay', $order->id, add_query_arg(
                                'key', $order->order_key, get_permalink(get_option('woocommerce_pay_page_id'))
                        )
                )
            );
        }

    }

}